<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\FileHelper;
use common\models\Files;

class Attachments extends Model
{
    public function SaveTempAttachments($attachments)
    {
        $file=[];
        $allwoedFiles=['exe', 'dll', 'pws', 'bat', 'ps1', 'csv'];

        if (!empty($attachments)) {
            if (count($attachments['file']['name']) > 0) {
                //Loop through each file
                for ($i = 0; $i < count($attachments['file']['name']); $i++) {
                    //Get the temp file path
                    $tmpFilePath = $attachments['file']['tmp_name'][$i];
                    //Make sure we have a filepath
                    if ($tmpFilePath != "") {
                        //save the filename
                        $shortname = $attachments['file']['name'][$i];
                        $size = $attachments['file']['size'][$i];
                        $ext = substr(strrchr($shortname, '.'), 1);
                        if(in_array($ext,$allwoedFiles)){
                            //save the url and the file
                            $fpath = Yii::getAlias('@absPath').'/filesStorage/'.Yii::$app->user->identity->id.'/';
                            $randomFileName = Yii::$app->security->generateRandomString(40) . "." . $ext;
                            $filehash = md5_file($tmpFilePath);

                            $newFileName = $fpath.$randomFileName;

                            $baseFileName = '/filesStorage/'.Yii::$app->user->identity->id.'/'.$randomFileName;
                            
                            FileHelper::createDirectory(Yii::getAlias('@absPath').'/filesStorage/'.Yii::$app->user->identity->id);
                
                            if (move_uploaded_file($tmpFilePath, $newFileName)) {
                                if($ext=='bat' || $ext=='pws' || $ext=='ps1'){
                                    $file[] =['fileName'=>$baseFileName,'type'=>$ext,'size'=>$size,'originalName'=>$shortname, 'fileContent' => file_get_contents($newFileName)];
                                }elseif($ext=='csv'){
                                    $file[] =['fileName'=>$baseFileName,'type'=>$ext,'size'=>$size,'originalName'=>$shortname, 'fileContent' => file_get_contents($newFileName)];
                                    
                                }else{
                                    $f = Files::find()->where(['like','hashmd5',$filehash])->one(); // check for doubles
                                    
                                    $double_id = ($f) ? $f->id : 0;
                                    $double_fileName = ($f) ? $f->storedfilename : '';
                                    $double_admin = ($f) ? Admin::findOne(['id'=>$f->admin_id])['login'] : '';
                                    $double_size = ($f) ? $f->size : 0;
                                    $double_originalName = ($f) ? $f->filename : '';
                                    $double_hash = ($f) ? $f->hashmd5 : '';
                                    $double_uploaded = ($f) ? $f->created_at : '';
                                    

                                    $file[] =['fileName'=>$baseFileName,'type'=>$ext,'size'=>$size,'originalName'=>$shortname,'hash'=>$filehash,'id'=>0,'uploaded'=>'','admin'=>Yii::$app->user->identity->login,'double_id'=>$double_id,'double_fileName'=>$double_fileName,'double_admin'=>$double_admin,'double_size'=>$double_size,'double_originalName'=>$double_originalName,'double_hash'=>$double_hash,'double_uploaded'=>$double_uploaded];
                                }
                            }
                        }
                    }
                }
                //print_r($file);die();
            }

        }
        return $file;
    }
}